/*
* hal_camclk_tbl.c- Sigmastar
*
* Copyright (c) [2019~2020] SigmaStar Technology.
*
*
* This software is licensed under the terms of the GNU General Public
* License version 2, as published by the Free Software Foundation, and
* may be copied, distributed, and modified under those terms.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License version 2 for more details.
*
*/

#define  HAL_CAMCLKTBL_C
#include "hal_camclk_if.h"
#include "hal_camclk_complex.h"
#include "reg_clks.h"
#include "hal_camclk_util.h"

const HalCamClkNode_t gCamClkSrcNode[HAL_CAMCLK_SRC_Id_MAX] =
{
    {HAL_CAMCLK_SRC_CLK_VOID, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_utmi_480m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={480000000}},
    {HAL_CAMCLK_SRC_CLK_mpll_432m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={432000000}},
    {HAL_CAMCLK_SRC_CLK_upll_384m, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_upll,5,4}},
    {HAL_CAMCLK_SRC_CLK_upll_320m, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_upll,3,2}},
    {HAL_CAMCLK_SRC_CLK_mpll_288m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={288000000}},
    {HAL_CAMCLK_SRC_CLK_utmi_240m, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_216m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={216000000}},
    {HAL_CAMCLK_SRC_CLK_utmi_192m, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi,5,2}},
    {HAL_CAMCLK_SRC_CLK_mpll_172m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={172800000}},
    {HAL_CAMCLK_SRC_CLK_utmi_160m, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi,3,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_123m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={123400000}},
    {HAL_CAMCLK_SRC_CLK_mpll_86m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={86400000}},
    {HAL_CAMCLK_SRC_CLK_mpll_288m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_288m,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_288m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_288m,4,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_288m_div8, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_288m,8,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_288m_div32, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_288m,32,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_216m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_216m,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_216m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_216m,4,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_216m_div8, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_216m,8,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_123m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_123m,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_86m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_86m,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_86m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_86m,4,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_86m_div16, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_86m,16,1}},
    {HAL_CAMCLK_SRC_CLK_utmi_192m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi_192m,4,1}},
    {HAL_CAMCLK_SRC_CLK_utmi_160m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi_160m,4,1}},
    {HAL_CAMCLK_SRC_CLK_utmi_160m_div5, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi_160m,5,1}},
    {HAL_CAMCLK_SRC_CLK_utmi_160m_div8, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_utmi_160m,8,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={12000000}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div8, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,8,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div16, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,16,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div40, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,40,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div64, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,64,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div128, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,128,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_24m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={24000000}},
    {HAL_CAMCLK_SRC_CLK_RTC_CLK_32K, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={32000}},
    {HAL_CAMCLK_SRC_CLK_pm_riu_w_clk_in, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_lpll_clk_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_lpll_clk,2,1}},
    {HAL_CAMCLK_SRC_CLK_lpll_clk_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_lpll_clk,4,1}},
    {HAL_CAMCLK_SRC_CLK_lpll_clk_div8, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_lpll_clk,8,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_in, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_top, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_sc_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_vhe_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_dec_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_hemcu_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_mipi_if_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_w_clk_mcu_if_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_mspi0_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mspi0,1,1}},
    {HAL_CAMCLK_SRC_CLK_mspi1_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mspi1,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_sc_gp_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu_sc_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu2x_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu2x,1,1}},
    {HAL_CAMCLK_SRC_CLK_mcu_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_mcu_pm_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu,1,1}},
    {HAL_CAMCLK_SRC_CLK_sdio_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_sdio,1,1}},
    {HAL_CAMCLK_SRC_CLK_fcie_p, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_tck_buf, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_pad2isp_sr_pclk, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_csi2_mac_p, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_mipi_tx_dsi_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mipi_tx_dsi,1,1}},
    {HAL_CAMCLK_SRC_CLK_sc_pixel_p, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_sc_pixel,1,1}},
    {HAL_CAMCLK_SRC_CLK_ccir_in_clk, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_eth_buf, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_rmii_buf, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_emac_testrx125_in_lan, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={1}},
    {HAL_CAMCLK_SRC_CLK_armpll_37p125m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={432000000}},
    {HAL_CAMCLK_SRC_CLK_hdmi_in, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={432000000}},
    {HAL_CAMCLK_SRC_CLK_dac_in, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={432000000}},
    {HAL_CAMCLK_SRC_CLK_miu_ff, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu_p,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_sc_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu_p,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_dec_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu_p,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_dig, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_urdma, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_miic0, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_miic1, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu_dma0, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_top,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_nogating, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_in,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_sc_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_sc_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_dec_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_dec_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_hemcu_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_hemcu_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_mipi_gp, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_mipi_if_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_mcu_if, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_riu_w_clk_mcu_if_gp,1,1}},
    {HAL_CAMCLK_SRC_CLK_miu2x, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_ddrpll_clk,1,1}},
    {HAL_CAMCLK_SRC_CLK_axi2x, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_miu2x_p,1,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_144m, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={144000000}},
    {HAL_CAMCLK_SRC_CLK_mpll_144m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_144m,2,1}},
    {HAL_CAMCLK_SRC_CLK_mpll_144m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mpll_144m,4,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div2, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,2,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,4,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_12m_div12, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_12m,12,1}},
    {HAL_CAMCLK_SRC_CLK_rtc_32k, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={32768}},
    {HAL_CAMCLK_SRC_CLK_rtc_32k_div4, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_rtc_32k,4,1}},
    {HAL_CAMCLK_SRC_CLK_live_pm, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_xtali_24m,1,1}},
    {HAL_CAMCLK_SRC_CLK_mcu_pm, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_mcu_p,1,1}},
    {HAL_CAMCLK_SRC_CLK_riu_pm, HAL_CAMCLK_TYPE_FIXED_FACTOR, .attribute.stFixedFac={HAL_CAMCLK_SRC_CLK_pm_riu_w_clk_in,1,1}},
    {HAL_CAMCLK_SRC_CLK_miupll_clk, HAL_CAMCLK_TYPE_COMPLEX, .attribute.stComplex={HAL_CAMCLK_SRC_CLK_xtali_24m,&gMiupllOps}},
    {HAL_CAMCLK_SRC_CLK_ddrpll_clk, HAL_CAMCLK_TYPE_COMPLEX, .attribute.stComplex={HAL_CAMCLK_SRC_CLK_ddr_syn,&gDdrpllOps}},
    {HAL_CAMCLK_SRC_CLK_lpll_clk, HAL_CAMCLK_TYPE_COMPLEX, .attribute.stComplex={HAL_CAMCLK_SRC_CLK_mpll_432m,&gLpllOps}},
    {HAL_CAMCLK_SRC_CLK_cpupll_clk, HAL_CAMCLK_TYPE_COMPLEX, .attribute.stComplex={HAL_CAMCLK_SRC_CLK_mpll_432m,&gCpupllOps}},
    {HAL_CAMCLK_SRC_CLK_utmi, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={480000000}},
    {HAL_CAMCLK_SRC_CLK_upll, HAL_CAMCLK_TYPE_FIXED, .attribute.stFixed={480000000}},
    {HAL_CAMCLK_SRC_CLK_fuart0_synth_out, HAL_CAMCLK_TYPE_COMPLEX, .attribute.stComplex={HAL_CAMCLK_SRC_CLK_fuart0_synth_in,&gFuart0Ops}},
    {HAL_CAMCLK_SRC_CLK_miu, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_ddrpll_clk,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_miupll_clk,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m},REG_CKG_MIU_BASE,camclk_BIT0,camclk_BIT4,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_miu_xd2miu, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_miu},REG_CHIPTOP_DUMMY_1_BASE,camclk_BIT0,0,0,0,1}},
    {HAL_CAMCLK_SRC_CLK_bdma, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_miu_p,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_BDMA_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_ddr_syn, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_DDR_SYN_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_miu_rec, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div64,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div128},REG_CKG_MIU_REC_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_mcu, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2},REG_CKG_MCU_BASE,camclk_BIT0,camclk_BIT5,3,2,1}},
    {HAL_CAMCLK_SRC_CLK_riubrdg, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mcu_p,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_RIUBRDG_BASE,camclk_BIT8,0,2,10,1}},
    {HAL_CAMCLK_SRC_CLK_spi, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div4,(u8)HAL_CAMCLK_SRC_CLK_miu_p,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_SPI_BASE,camclk_BIT8,0,3,10,1}},
    {HAL_CAMCLK_SRC_CLK_uart0, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_UART0_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_uart1, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_UART1_BASE,camclk_BIT8,0,2,10,0}},
    {HAL_CAMCLK_SRC_CLK_uart2, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_UART2_BASE,camclk_BIT12,0,2,14,0}},
    {HAL_CAMCLK_SRC_CLK_fuart0_synth_in, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_FUART0_SYNTH_IN_BASE,camclk_BIT4,0,2,6,0}},
    {HAL_CAMCLK_SRC_CLK_fuart, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_fuart0_synth_out},REG_CKG_FUART_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_mspi0, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2},REG_CKG_MSPI0_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_mspi1, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2},REG_CKG_MSPI1_BASE,camclk_BIT8,0,2,10,0}},
    {HAL_CAMCLK_SRC_CLK_mspi, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mspi0_p,(u8)HAL_CAMCLK_SRC_CLK_mspi1_p},REG_CKG_MSPI_BASE,camclk_BIT12,0,1,14,0}},
    {HAL_CAMCLK_SRC_CLK_miic0, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_MIIC0_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_miic1, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_MIIC1_BASE,camclk_BIT8,0,2,10,0}},
    {HAL_CAMCLK_SRC_CLK_bist, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m},REG_CKG_BIST_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_pwr_ctl, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_PWR_CTL_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_xtali, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_XTALI_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_live_c, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_LIVE_BASE,camclk_BIT8,0,2,10,1}},
    {HAL_CAMCLK_SRC_CLK_live, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_LIVE_BASE,camclk_BIT8,0,2,10,1}},
    {HAL_CAMCLK_SRC_CLK_sata_phy_108, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_SATA_PHY_108_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_sata_phy_432, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_SATA_PHY_432_BASE,camclk_BIT8,0,2,10,0}},
    {HAL_CAMCLK_SRC_CLK_disp_432, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_DISP_432_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_bist_dec_gp, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m},REG_CKG_BIST_DEC_GP_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_dec_pclk, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_DEC_PCLK_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_dec_aclk, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m},REG_CKG_DEC_ACLK_BASE,camclk_BIT8,0,2,10,1}},
    {HAL_CAMCLK_SRC_CLK_dec_bclk, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CLKGEN0_RESERVED0_BASE,camclk_BIT0,0,3,2,1}},
    {HAL_CAMCLK_SRC_CLK_dec_cclk, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CLKGEN0_RESERVED0_BASE,camclk_BIT8,0,3,10,1}},
    {HAL_CAMCLK_SRC_CLK_xtali_sc_gp, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_XTALI_SC_GP_BASE,camclk_BIT4,0,2,6,0}},
    {HAL_CAMCLK_SRC_CLK_bist_sc_gp, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m},REG_CKG_BIST_SC_GP_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_emac_ahb, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_123m,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_emac_testrx125_in_lan},REG_CKG_EMAC_AHB_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_jpe, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_JPE_BASE,camclk_BIT0,0,3,2,0}},
    {HAL_CAMCLK_SRC_CLK_aesdma, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_AESDMA_BASE,camclk_BIT0,camclk_BIT4,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_sdio, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_utmi_192m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m_div2,(u8)HAL_CAMCLK_SRC_CLK_utmi_160m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div8,(u8)HAL_CAMCLK_SRC_CLK_utmi_160m_div5,(u8)HAL_CAMCLK_SRC_CLK_utmi_160m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div40},REG_CKG_SDIO_BASE,camclk_BIT0,0,3,2,0}},
    {HAL_CAMCLK_SRC_CLK_dip, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_utmi_192m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_utmi_160m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_DIP_BASE,camclk_BIT0,0,3,2,0}},
    {HAL_CAMCLK_SRC_CLK_ge, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_miu_p,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_mpll_432m,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_GE_BASE,camclk_BIT0,0,3,2,0}},
    {HAL_CAMCLK_SRC_CLK_mop, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_upll_320m,(u8)HAL_CAMCLK_SRC_CLK_upll_384m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_utmi_240m},REG_CKG_MOP_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_disp_216, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2},REG_CKG_DISP_216_BASE,camclk_BIT8,0,1,10,1}},
    {HAL_CAMCLK_SRC_CLK_sc_pixel, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_utmi_240m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_utmi_192m,(u8)HAL_CAMCLK_SRC_CLK_mpll_172m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_123m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_lpll_clk,(u8)HAL_CAMCLK_SRC_CLK_lpll_clk_div2,(u8)HAL_CAMCLK_SRC_CLK_lpll_clk_div4,(u8)HAL_CAMCLK_SRC_CLK_lpll_clk_div8,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div8,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div32},REG_CKG_SC_PIXEL_BASE,camclk_BIT0,0,4,2,0}},
    {HAL_CAMCLK_SRC_CLK_sata_pm, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_xtali_24m,(u8)HAL_CAMCLK_SRC_CLK_mpll_123m},REG_CKG_SATA_PM_BASE,camclk_BIT8,0,2,10,0}},
    {HAL_CAMCLK_SRC_CLK_sata_axi, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_utmi_240m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_SATA_AXI_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_mipi_tx_dsi, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_lpll_clk,(u8)HAL_CAMCLK_SRC_CLK_utmi_160m,(u8)HAL_CAMCLK_SRC_CLK_mpll_288m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m,(u8)HAL_CAMCLK_SRC_CLK_utmi_240m,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_MIPI_TX_DSI_BASE,camclk_BIT0,0,3,2,1}},
    {HAL_CAMCLK_SRC_CLK_mipi_tx_dsi_apb, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mcu_p,(u8)HAL_CAMCLK_SRC_CLK_mipi_tx_dsi_p,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_MIPI_TX_DSI_APB_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_hdmi, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_hdmi_in,(u8)HAL_CAMCLK_SRC_CLK_sc_pixel_p,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_HDMI_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_dac, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_dac_in,(u8)HAL_CAMCLK_SRC_CLK_hdmi_in,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_DAC_BASE,camclk_BIT0,0,2,2,1}},
    {HAL_CAMCLK_SRC_CLK_emac1_tx, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_eth_buf,(u8)HAL_CAMCLK_SRC_CLK_rmii_buf},REG_CKG_EMAC1_TX_BASE,camclk_BIT0,0,1,2,0}},
    {HAL_CAMCLK_SRC_CLK_emac1_rx, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_eth_buf,(u8)HAL_CAMCLK_SRC_CLK_rmii_buf},REG_CKG_EMAC1_RX_BASE,camclk_BIT0,0,1,2,0}},
    {HAL_CAMCLK_SRC_CLK_emac1_tx_ref, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_rmii_buf,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_EMAC1_TX_REF_BASE,camclk_BIT8,0,1,10,0}},
    {HAL_CAMCLK_SRC_CLK_emac1_rx_ref, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_rmii_buf,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_EMAC1_RX_REF_BASE,camclk_BIT8,0,1,10,0}},
    {HAL_CAMCLK_SRC_CLK_emac_tx, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_eth_buf,(u8)HAL_CAMCLK_SRC_CLK_rmii_buf},REG_CKG_EMAC_TX_BASE,camclk_BIT0,0,1,2,0}},
    {HAL_CAMCLK_SRC_CLK_emac_rx, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_eth_buf,(u8)HAL_CAMCLK_SRC_CLK_rmii_buf},REG_CKG_EMAC_RX_BASE,camclk_BIT0,0,1,2,0}},
    {HAL_CAMCLK_SRC_CLK_emac_tx_ref, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_rmii_buf,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_EMAC_TX_REF_BASE,camclk_BIT8,0,1,10,0}},
    {HAL_CAMCLK_SRC_CLK_emac_rx_ref, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_rmii_buf,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_EMAC_RX_REF_BASE,camclk_BIT8,0,1,10,0}},
    {HAL_CAMCLK_SRC_CLK_hemcu_216m, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_mpll_216m},REG_CKG_HEMCU_216M_BASE,camclk_BIT0,0,0,0,1}},
    {HAL_CAMCLK_SRC_CLK_spi_pm, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div8,(u8)HAL_CAMCLK_SRC_CLK_mpll_144m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_144m_div2,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_mpll_216m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div12,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_xtali_24m},REG_CKG_SPI_BASE,camclk_BIT8,camclk_BIT14,4,10,1}},
    {HAL_CAMCLK_SRC_CLK_pm_sleep, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div12,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div4},REG_CKG_PM_SLEEP_BASE,0,0,3,12,1}},
    {HAL_CAMCLK_SRC_CLK_pwm, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div12,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k_div4,(u8)HAL_CAMCLK_SRC_CLK_mpll_86m,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div4},REG_CKG_PWM_BASE,0,0,3,12,0}},
    {HAL_CAMCLK_SRC_CLK_sar, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div12,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div4},REG_CKG_SAR_BASE,camclk_BIT5,0,3,7,1}},
    {HAL_CAMCLK_SRC_CLK_rtc, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_VOID,(u8)HAL_CAMCLK_SRC_CLK_VOID},REG_CKG_RTC_BASE,camclk_BIT0,0,2,2,0}},
    {HAL_CAMCLK_SRC_CLK_ir, HAL_CAMCLK_TYPE_COMPOSITE, .attribute.stComposite={{(u8)HAL_CAMCLK_SRC_CLK_xtali_12m,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div8,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div12,(u8)HAL_CAMCLK_SRC_CLK_rtc_32k_div4,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div16,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div2,(u8)HAL_CAMCLK_SRC_CLK_xtali_12m_div4},REG_CKG_IR_BASE,camclk_BIT5,0,3,7,0}},
};

#undef  HAL_CAMCLKTBL_C
